#include <stdio.h>
#include <string>
#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <string>
#include <cstring>
#include <vector>
#include <cctype>

using namespace std;

template <typename T>
int len(T args) { return args.size(); }

vector<string> split(string &s, const char &c)
{
    string buffer{""};

    vector<string> resultado;

    for (char caractere : s)
    {
        if (caractere != c)
        {
            buffer += caractere;
        }
        else
        {
            resultado.push_back(buffer);
            buffer = "";
        }
    }
    if (buffer != "")
    {
        resultado.push_back(buffer);
        buffer = "";
    }

    return resultado;
}

static int letToNum(char let)
{
    switch (let)
    {
    case 'I':
        return 1;
    case 'V':
        return 5;
    case 'X':
        return 10;
    case 'L':
        return 50;
    case 'C':
        return 100;
    case 'D':
        return 500;
    case 'M':
        return 1000;
    default:
        return -1;
    }
}

static string ConvDecRom(int n)
{
    int nums[] = {1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    string lets[] = {"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    string romano = "";

    int length = sizeof(nums) / sizeof(nums[0]);

    for (int i = 0; i < length; i++)
    {
        while (n >= nums[i])
        {
            romano += lets[i];
            n -= nums[i];
        }
    }
    return romano;
}

static string toUpperCase(string s)
{
    for (int i = 0; i <= s.length(); i++)
    {
        if (s[i] >= 97 && s[i] <= 122)
        {
            s[i] = s[i] - 32;
        }
    }
    return s;
}

static int ConvRomDec(string romano)
{

    if (romano.length() == 0)
    {
        cout << "Uma string vazia não é um numeral romano.";
    }

    romano = toUpperCase(romano);

    int i = 0;
    int arabico = 0;

    while (i < romano.length())
    {

        int n = romano.length();

        char char_array[n + 1];

        strcpy(char_array, romano.c_str());

        char let = char_array[i];
        int num = letToNum(let);

        if (num < 0)
        {
            cout << "Caractere Ilegal \"" << let << "\" em números romanos.";
        }

        i++;

        if (i == romano.length())
        {
            arabico += num;
        }
        else
        {
            int proxNum = letToNum(char_array[i]);
            if (proxNum > num)
            {
                arabico += (proxNum - num);
                i++;
            }
            else
            {
                arabico += num;
            }
        }
    }

    if (arabico > 3999)
    {
        cout << "Numeral Romano só pode ter valores até 3999.";
    }

    return arabico;
}

int main(int argc, char **argv)
{

    int cont = 0;

    string linha;

    while (true)
    {
        getline(cin, linha);

        if (linha == "0")
        {
            break;
        }

        vector<string> temp = split(linha, '+');

        int length = len(temp);
        int soma = 0;

        for (int y = 0; y < length; y++)
        {
            soma += ConvRomDec(temp[y]);
        }

        string resultado = ConvDecRom(soma);

        cout << resultado << endl;
    }
    return 0;
}
